*! version 4.0
* 30 May 2021
* NIDS-CRAM W5
* Coding employment status

*==============================================================================================================================================================

* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

global DataIN "C:\Users\Admin\Desktop\NIDS-CRAM\W5"    			 //File path to where data is located. Change this path according to where your data folder in located on your computer.
global DataOUT "C:\Users\Admin\Desktop\NIDS-CRAM\W5"

global temp "C:\Users\Admin\Desktop\NIDS-CRAM\W5"				// tempfile to hold all the working datasets, all working datasets will
																// be deleted from this folder at the completion of the do file execution.
global VersionIN "Wave5_Anon_V1.0.0"
global VersionOUT "Derived"																

version 12.0													// version of Stata being used, this is needed for the rename command.

set more off

*==============================================================================================================================================================
	
use "$DataIN\NIDS-CRAM_$VersionIN.dta", clear

cap rename w5_nc_* *

keep if outcome == 1      // keeping only completed interviews

*--------------------------------------------------------------------------------------------------------------------------------------------------------------
* Generating employment in March variable
*--------------------------------------------------------------------------------------------------------------------------------------------------------------

* Controlling for non-response
foreach x in em_mar emany_mar ems_mar emwnt emreturn {
replace `x' = . if `x' <0
}

gen Employed=0
replace Employed=1 if (em_mar==1| emany_mar==1| ems_mar==1| ems_mar==2| emreturn==1)
replace Employed=. if em_mar==. & emany_mar==. & ems_mar==. & emwnt==. & emreturn==. 

* Not employed and not available or willing to be employed in the next 7 days
gen Not_economically_active= (Employed==0 & emwnt==2)

* Not employed, is available and willing (emwnt = 1 [Yes]), actively searched (unems_mar = 2 [No])
gen Unemployed_discouraged= (Employed==0 & emwnt==1 & unems_mar == 2)

* Not employed, is available and willing (emwnt = 1 [Yes]), actively searched (unems_mar = 1 [Yes])
gen Unemployed_strict= (Employed==0 & emwnt==1 & unems_mar == 1)

gen state=.
replace state=0 if Not_economically_active==1
replace state=1 if Unemployed_discouraged==1
replace state=2 if Unemployed_strict==1
replace state=3 if Employed==1
replace state=-8 if state == . & outcome == 1
replace state=. if outcome != 1

la def state 0"Not Economically Active" 1"Unemployed_Discouraged" 2"Unemployed_Strict" 3"Employed" -8"Refused"
la val state state

ren state state_fine_a

recode state_fine_a (0=0)(1/2 = 1)(3=2)(-8=-8), gen(state2)
la def state2 0"Not Economically Active" 1"Unemployed" 2"Employed" -8"Refused"
la val state2 state2

rename state2 state_coarse_a

ren state_coarse_a w5_empl_stat_broad
ren state_fine_a   w5_empl_stat_narrow

lab var w5_empl_stat_broad "Employment status: March 2021 - Broad definition"
lab var w5_empl_stat_narrow "Employment status: March 2021 - Narrow definition"

tab w5_empl_stat_narrow w5_empl_stat_broad

drop w5_empl_stat_broad
rename w5_empl_stat_narrow w5_empl_stat

* Now correct for refusals to NEA
replace w5_empl_stat=0 if em_mar==3

lab var w5_empl_stat "Employment status: March 2021"

*--------------------------------------------------------------------------------------------------------------------------------------------------------------
* Keep employment variables
*--------------------------------------------------------------------------------------------------------------------------------------------------------------

keep pid w5_empl_stat

save "$DataOUT\Emp_status.dta", replace
